function [freq,psdx] = power_spec_fft(x,Fs)

%x = signal
%Fs = sample rate
%freq = output frequency vector
%psd = power spectrum in units of signal^2/time unit

N = length(x);
xdft = fft(x);
xdft = xdft(1:N/2+1);
psdx = (1/(Fs*N)) * abs(xdft).^2;
% mulitiply by two to preserve total power from positive and neg freqs
psdx(2:end-1) = 2*psdx(2:end-1);
freq = 0:Fs/length(x):Fs/2;

end
